/*
	ENGCore.cpp
	This file serves as the core for the engine, performing the engine loop.
	Copyright 2002 Ben Everett and Chris Horlick.
	All Rights Reserved.
*/

#include "pch.h"

// Engine Includes
#include "Socket.h"
#include "BSDSocket.h"
#include "WinSocket.h"
#include "ENGCore.h"

using namespace CPPMUD;

// Constructor & Deconstructor
CENGCore::CENGCore()
{
	m_bQuit = false;
	m_pSocket = NULL;
}

CENGCore::~CENGCore()
{
	if (m_pSocket)
		delete m_pSocket;

	m_pSocket = NULL;
}

// Functions
void CENGCore::EngineLoop()
{
	char czMessage[] = "You alive?\r\n";
#ifdef _WIN32
	m_pSocket = new CWinSocket;
#else
	m_pSocket = new CBSDSocket;
#endif

	if (!m_pSocket)
		return;

	// Unable to initialize sockets.
	if (m_pSocket->InitSockets() != errNone)
	{
		if (m_pSocket)
			delete m_pSocket;

		m_pSocket = NULL;

		return;
	}

	// Unable to listen on port 8000.
	if (m_pSocket->Listen(8000) != errNone)
	{
		if (m_pSocket)
			delete m_pSocket;

		m_pSocket = NULL;

		return;
	}

	// Engine loop.
	while (!m_bQuit)
	{
		char czCommand[1024] = "";

		memset(czCommand, 0, sizeof(char) * 1024);

		if (m_pSocket->CheckForNewData() != errNone)
			break;

		for (int i = 0; i < m_pSocket->m_vecClients.size(); ++i)
		{
			int nLen = 0;

			if (m_pSocket->m_vecClients[i].IsInputPending())
			{
				nLen = m_pSocket->m_vecClients[i].GetLineFromInputBuffer(czCommand, 1024);

				m_pSocket->SendData(czCommand, nLen, m_pSocket->m_vecClients[i].GetClientID());

				memset(czCommand, 0, sizeof(char) * 1024);
			}
		}

		// Sleep for 100 milliseconds, to simulate ~10FPS... don't want to take up the entire CPU.
		// *NOTE* Change this for your purposes, we just threw this in here for this wrapper 
		//    example. Our architecture is different from this examples. :)
		Sleep(100);
	}

	// Close all sockets.
	m_pSocket->CloseSockets();

	// De-allocate the socket.
	if (m_pSocket)
		delete m_pSocket;

	m_pSocket = NULL;
}